/*
 * Decompiled with CFR 0.152.
 */
package com.github.glodblock.extendedae.container;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Settings;
import appeng.api.config.StorageFilter;
import appeng.api.config.YesNo;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.api.util.IConfigManager;
import appeng.menu.guisync.GuiSync;
import appeng.menu.implementations.MenuTypeBuilder;
import appeng.menu.implementations.UpgradeableMenu;
import com.github.glodblock.extendedae.common.parts.PartModStorageBus;
import com.github.glodblock.extendedae.network.EAENetworkServer;
import com.github.glodblock.extendedae.network.packet.SGenericPacket;
import com.github.glodblock.extendedae.network.packet.sync.IActionHolder;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContainerModStorageBus
extends UpgradeableMenu<PartModStorageBus>
implements IActionHolder {
    private final Map<String, Consumer<Object[]>> actions = new Object2ObjectOpenHashMap();
    private static final String ACTION_PARTITION = "partition";
    public static final class_3917<ContainerModStorageBus> TYPE = MenuTypeBuilder.create(ContainerModStorageBus::new, PartModStorageBus.class).build("mod_storage_bus");
    @GuiSync(value=3)
    public AccessRestriction rwMode = AccessRestriction.READ_WRITE;
    @GuiSync(value=4)
    public StorageFilter storageFilter = StorageFilter.EXTRACTABLE_ONLY;
    @GuiSync(value=7)
    public YesNo filterOnExtract = YesNo.YES;
    @GuiSync(value=8)
    @Nullable
    public class_2561 connectedTo;
    @GuiSync(value=9)
    public String exp = "";

    public ContainerModStorageBus(int id, class_1661 ip, PartModStorageBus te) {
        super(TYPE, id, ip, (IUpgradeableObject)te);
        this.registerClientAction(ACTION_PARTITION, this::partition);
        this.actions.put("set", o -> this.setExp((String)o[0]));
        this.actions.put("update", o -> {
            class_1657 patt2246$temp = this.getPlayer();
            if (patt2246$temp instanceof class_3222) {
                class_3222 sp = (class_3222)patt2246$temp;
                EAENetworkServer.INSTANCE.sendTo(new SGenericPacket("init", this.exp), sp);
            }
        });
        this.connectedTo = te.getConnectedToDescription();
    }

    protected void setupConfig() {
    }

    public void method_7623() {
        super.method_7623();
        this.connectedTo = ((PartModStorageBus)this.getHost()).getConnectedToDescription();
        if (!this.exp.equals(((PartModStorageBus)this.getHost()).getModNameFilter())) {
            this.exp = ((PartModStorageBus)this.getHost()).getModNameFilter();
        }
    }

    protected void loadSettingsFromHost(IConfigManager cm) {
        this.setReadWriteMode((AccessRestriction)cm.getSetting(Settings.ACCESS));
        this.setStorageFilter((StorageFilter)cm.getSetting(Settings.STORAGE_FILTER));
        this.setFilterOnExtract((YesNo)cm.getSetting(Settings.FILTER_ON_EXTRACT));
    }

    public boolean isSlotEnabled(int idx) {
        return false;
    }

    public void partition() {
        if (this.isClientSide()) {
            this.sendClientAction(ACTION_PARTITION);
            return;
        }
        this.method_7623();
    }

    public void setExp(String exp) {
        ((PartModStorageBus)this.getHost()).setModNameFilter(exp);
        this.method_7623();
    }

    public AccessRestriction getReadWriteMode() {
        return this.rwMode;
    }

    private void setReadWriteMode(AccessRestriction rwMode) {
        this.rwMode = rwMode;
    }

    public StorageFilter getStorageFilter() {
        return this.storageFilter;
    }

    private void setStorageFilter(StorageFilter storageFilter) {
        this.storageFilter = storageFilter;
    }

    public YesNo getFilterOnExtract() {
        return this.filterOnExtract;
    }

    public void setFilterOnExtract(YesNo filterOnExtract) {
        this.filterOnExtract = filterOnExtract;
    }

    @Nullable
    public class_2561 getConnectedTo() {
        return this.connectedTo;
    }

    @Override
    @NotNull
    public Map<String, Consumer<Object[]>> getActionMap() {
        return this.actions;
    }
}

